package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Coyot_F_bumper extends Bumper
{
	public Coyot_F_bumper( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Coyot front bumper";

		value = 350;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_01.coyot:0x000000E0r, "F grill", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x000000E0r, "F grill", actcolor, optical, power );
		}
	}
}
